/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.Modifier;

import com.c2h6s.etshtinker.Modifiers.modifiers.EtSTBaseModifier;
import com.hoshino.cti.Cti;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.RepairFactorModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.VolatileDataModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

@Mod.EventBusSubscriber(modid="cti")
public class IndustrialArmor
extends EtSTBaseModifier
implements VolatileDataModifierHook,
ToolDamageModifierHook,
RepairFactorModifierHook {
    public static final TinkerDataCapability.TinkerDataKey<Integer> KEY_INDUSTRIAL = TinkerDataCapability.TinkerDataKey.of((ResourceLocation)Cti.getResource("industrial"));

    public float getRepairFactor(IToolStackView tool, ModifierEntry entry, float factor) {
        return factor * (1.0f + (float)entry.getLevel() * 0.05f);
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        if (event.getEntity() != null && !event.getSource().m_19376_()) {
            event.getEntity().getCapability(TinkerDataCapability.CAPABILITY).ifPresent(cap -> {
                int level = (Integer)cap.get(KEY_INDUSTRIAL, (Object)0);
                if (level > 0) {
                    level = Math.min(16, level);
                    event.setAmount(event.getAmount() * (1.0f - (float)level * 0.05f));
                }
            });
        }
    }

    protected void registerHooks(ModuleHookMap.Builder builder) {
        super.registerHooks(builder);
        builder.addHook((Object)this, ModifierHooks.VOLATILE_DATA);
        builder.addHook((Object)this, ModifierHooks.TOOL_DAMAGE);
        builder.addHook((Object)this, ModifierHooks.REPAIR_FACTOR);
        builder.addModule((HookProvider)new ArmorLevelModule(KEY_INDUSTRIAL, false, null));
    }

    public void addVolatileData(IToolContext context, ModifierEntry modifier, ModDataNBT volatileData) {
        volatileData.addSlots(SlotType.ABILITY, 1);
        volatileData.addSlots(SlotType.DEFENSE, 1);
    }

    public void addToolStats(IToolContext context, ModifierEntry modifier, ModifierStatsBuilder builder) {
        super.addToolStats(context, modifier, builder);
        ToolStats.ARMOR.percent(builder, 0.05 * (double)modifier.getLevel());
        ToolStats.ARMOR_TOUGHNESS.percent(builder, 0.05 * (double)modifier.getLevel());
    }

    public int onDamageTool(IToolStackView tool, ModifierEntry modifier, int amount, @Nullable LivingEntity holder) {
        if ((double)RANDOM.nextFloat() > Math.min(0.8, (double)modifier.getLevel() * 0.05)) {
            return 0;
        }
        if (amount > 2) {
            amount = 2;
        }
        return amount;
    }
}

